/* do unemployment and employment graphs with BLS comparable US/Ger data  */
/* Michael wants GDP, hours on same graph - hours won't be comparable */

* read in German info
use /Users/hunt/Desktop/Nervecenter/research/BPEA_recession/data/macro_q
* merge in US/D unemp and empl rates from BLS
sort year_q
merge year_q using "/Users/hunt/Desktop/Nervecenter/research/BPEA_recession/data/BLS/unemp_q.dta"
tab _merge
drop _merge
* merge in US real GDP
sort year_q
merge year_q using "/Users/hunt/Desktop/Nervecenter/research/BPEA_recession/data/BEA/gdp.dta"
tab _merge
drop _merge
* merge in US total hours but NOT COMPARABLE because PRIVATE sector only
* only q2 2006+
sort year_q
merge year_q using "/Users/hunt/Desktop/Nervecenter/research/BPEA_recession/data/BLS/hourswork_q_us.dta"
tab _merge
drop _merge
* merge in US labor force based on CPS (who knows if comparable to Germany)
sort year quarter
merge year quarter using "/Users/hunt/Desktop/Nervecenter/research/BPEA_recession/data/BLS/laborforce_q_us.dta"
tab _merge
drop _merge
drop if year<=1969
* merge in estimated TOTAL NONFARM HOURS by Hobijn 1979+, originally monthly
sort year_q
merge year_q using "/Users/hunt/Desktop/Nervecenter/research/BPEA_recession/data/Elsby-Hobijn/totalhours_q_us.dta"
tab _merge
drop _merge
* merge in UK real (hope) GDP index (2003=100)
sort year_q
merge year_q using "/Users/hunt/Desktop/Nervecenter/research/BPEA_recession/data/UK/gdp_uk"
tab _merge
drop _merge

* make employment indices start at 100 in Q1 2007
replace empli_us=empli_us/1.058
replace empli_d=empli_d/.983
replace empli_uk=empli_uk/1.006

* same for labor force
gen lforcei_d=100*(laborforce_u/43217)
gen lforcei_us=100*(laborforce_us/153051)

* same for GDP
gen gdpi_d=100*(gdp_r/108.75)
gen gdpi_us=100*(gdp_r_us/13089.3)
gen gdpi_uk=gdp_r_uk/1.099

* same for hours worked
gen hoursworki_d=100*(hourswork/14172)
gen hoursworki_us=100*(hourswork_q_us/3974608)
gen hoursworki_usH=100*(hourswork_usH/4978410)
gen hoursworki_uk=100*(hourswork_uk/932)

* for germany, do by sector
gen emplagi=(emplag/531.9903)*100
gen emplmani=(emplman/6203.564)*100
gen emplconsi=(emplcons/1666.869)*100
gen empltradei=(empltrade/8122.589)*100
gen emplfini=(emplfin/5901.553)*100
gen emplservi=(emplserv/9458.608)*100

* also do for Q1 1973=100
gen emplagi2=(emplag/1954)*100
gen emplmani2=(emplman/9848)*100
gen emplconsi2=(emplcons/2361)*100
gen empltradei2=(empltrade/6102)*100
gen emplfini2=(emplfin/1778)*100
gen emplservi2=(emplserv/5060)*100

* repeat for value-added
gen vaagi=(vaag_r/0.9351)*100
gen vamani=(vaman_r/29.53)*100
gen vaconsi=(vacons_r/4.544)*100
gen vatradei=(vatrade_r/19.111)*100
gen vafini=(vafin_r/34.285)*100
gen vaservi=(vaserv_r/23.743)*100

* also do for Q1 1973=100
gen vaagi2=(vaag_r/1.676476)*100
gen vamani2=(vaman_r/21.3777)*100
gen vaconsi2=(vacons_r/4.6023)*100
gen vatradei2=(vatrade_r/10.7263)*100
gen vafini2=(vafin_r/8.8042)*100
gen vaservi2=(vaserv_r/10.2137)*100

do labelquarters
* figure to graph us/german gdp/unemp/empl/hours
do ~/research/BPEA_recession/statprog/figure1.do
replace year_q=year_q/100

* figure to compare current and past german recessions
do ~/research/BPEA_recession/statprog/figure2.do

* figure to plot the components of GDP, and plain GDP
do ~/research/BPEA_recession/statprog/gdpfig.do

* figure to plot labor force
do ~/research/BPEA_recession/statprog/lfgraph.do

* other figures
do ~/research/BPEA_recession/statprog/figuremisc.do
